/*
 * Internal data and definitions used in libfma
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

/*
 * prototypes
 */
void lf_error_print(const char *fmt, ...);

#define LF_ERROR(p)                                 \
  do {                                              \
    errno = 0;					    \
    LF_ERROR_E(p);				    \
  } while (0)

#define LF_ERROR_E(p)							\
  do {									\
    if (lf_error_rtn == NULL) {						\
      fprintf(stderr, "%s:%d:", __FILE__, __LINE__);			\
      lf_error_print p;                                                 \
      if (errno != 0) { perror(" "); errno=0; }				\
      else fprintf(stderr, "\n");					\
    } else {								\
      char *__errstr;							\
      int __en = errno;							\
      __errstr = lf_error_msg_fmt p;					\
      lf_error_rtn(__FILE__,__LINE__,__en,__errstr);                    \
      lf_error_msg_free(__errstr);                                      \
    }                                                                   \
    goto except;							\
  } while (0)

extern void (*lf_error_rtn)(char *, int, int, char *);
